unit enigma_ide;

interface

const
  WM_PUBLIC         = 1;
  WM_PRIVATE        = 2;

  MAX_STRING_SIZE   = 255;

type
  TWMContent = record
    WMType      : integer;
    Name        : pchar;
    NameLen     : integer;
    Text        : pchar;
    TextLen     : integer;
    FileName    : pchar;
    FileNameLen : integer;
    AFile       : pointer;
    AFileLen    : integer;
  end;
  PWMContent = ^TWMContent;

{API for registration}
function EP_RegSaveKey ( Name : PChar; Key : PChar) : boolean; stdcall;
function EP_RegLoadKey( var Name : PChar; var Key : PChar) : boolean; stdcall;
function EP_RegDeleteKey : boolean; stdcall;
function EP_RegCheckKey ( Name : PChar; Key : PChar) : boolean; stdcall;
function EP_RegLoadAndCheckKey : boolean; stdcall;
function EP_RegCheckAndSaveKey(  Name : PChar; Key : PChar) : boolean; stdcall;
function EP_RegHardwareID : PChar; stdcall;
function EP_RegKeyCreationDate( var Year, Month, Day : WORD) : boolean; stdcall;
function EP_RegKeyExpirationDate( var Year, Month, Day : WORD) : boolean; stdcall;
{API for trial}
function EP_TrialExecutions( var Total, Left : WORD) : boolean; stdcall;
function EP_TrialDays( var Total, Left : WORD) : boolean; stdcall;
function EP_TrialExpirationDate( var Year, Month, Day : WORD) : boolean; stdcall;
function EP_TrialDateTillDate( var StartYear, StartMonth, StartDay, EndYear, EndMonth, EndDay : WORD) : boolean; stdcall;
function EP_TrialExecutionTime( var Total, Left : Cardinal) : boolean; stdcall;
{API Misc}
function EP_MiscGetWatermark(ID : integer; WM : PWMContent) : integer; stdcall;
{API Protection}
function EP_ProtectedStringByID(ID : integer; Buffer : pointer; Len : integer) : integer; stdcall;
function EP_ProtectedStringByKey(Key : pchar; Buffer : pointer; Len : integer) : integer; stdcall;

implementation

const
  enigma_api_dll_name  = 'enigma_ide.dll';

function EP_RegSaveKey ( Name : PChar; Key : PChar) : boolean; external enigma_api_dll_name name 'EP_RegSaveKey';
function EP_RegLoadKey( var Name : PChar; var Key : PChar) : boolean; external enigma_api_dll_name name 'EP_RegLoadKey';
function EP_RegDeleteKey : boolean; external enigma_api_dll_name name 'EP_RegDeleteKey';
function EP_RegCheckKey ( Name : PChar; Key : PChar) : boolean; external enigma_api_dll_name name 'EP_RegCheckKey';
function EP_RegCheckAndSaveKey(Name : PChar; Key : PChar) : boolean; external enigma_api_dll_name name 'EP_RegCheckAndSaveKey';
function EP_RegLoadAndCheckKey : boolean; external enigma_api_dll_name name 'EP_RegLoadAndCheckKey';
function EP_RegHardwareID : PChar; external enigma_api_dll_name name 'EP_RegHardwareID';
function EP_RegKeyCreationDate( var Year, Month, Day : WORD) : boolean; external enigma_api_dll_name name 'EP_RegKeyCreationDate';
function EP_RegKeyExpirationDate( var Year, Month, Day : WORD) : boolean; external enigma_api_dll_name name 'EP_RegKeyExpirationDate';

function EP_TrialExecutions( var Total, Left : WORD) : boolean; external enigma_api_dll_name name 'EP_TrialExecutions';
function EP_TrialDays( var Total, Left : WORD) : boolean; external enigma_api_dll_name name 'EP_TrialDays';
function EP_TrialExpirationDate( var Year, Month, Day : WORD) : boolean; external enigma_api_dll_name name 'EP_TrialExpirationDate';
function EP_TrialDateTillDate( var StartYear, StartMonth, StartDay, EndYear, EndMonth, EndDay : WORD) : boolean; external enigma_api_dll_name name 'EP_TrialDateTillDate';
function EP_TrialExecutionTime( var Total, Left : Cardinal) : boolean; external enigma_api_dll_name name 'EP_TrialExecutionTime';

function EP_MiscGetWatermark(ID : integer; WM : PWMContent) : integer; external enigma_api_dll_name name 'EP_MiscGetWatermark';

function EP_ProtectedStringByID(ID : integer; Buffer : pointer; Len : integer) : integer; external enigma_api_dll_name name 'EP_ProtectedStringByID';
function EP_ProtectedStringByKey(Key : pchar; Buffer : pointer; Len : integer) : integer; external enigma_api_dll_name name 'EP_ProtectedStringByKey';

end.
